
-- 
-- Database: `pcrt`
-- 

-- --------------------------------------------------------

CREATE TABLE `assetphotos` (
  `assetphotoid` int(11) NOT NULL auto_increment,
  `pcid` int(11) NOT NULL,
  `photofilename` text NOT NULL,
  `highlight` int(11) NOT NULL default '0',
  PRIMARY KEY  (`assetphotoid`)
) ENGINE=MyISAM ;


-- 
-- Table structure for table `attachments`
-- 

CREATE TABLE `attachments` (
  `attach_id` int(11) NOT NULL auto_increment,
  `attach_title` text NOT NULL,
  `attach_filename` text NOT NULL,
  `attach_size` int(11) NOT NULL,
  `attach_dcount` int(11) NOT NULL,
  `attach_keywords` text NOT NULL,
  `pcid` int(11) NOT NULL,
  `woid` int(11) NOT NULL,
  `groupid` int(11) NOT NULL,
  `attach_cat` int(11) NOT NULL,
  `attach_date` datetime NOT NULL,
  UNIQUE KEY `attach_id` (`attach_id`)
) ENGINE=MyISAM AUTO_INCREMENT=27 DEFAULT CHARSET=latin1 AUTO_INCREMENT=27 ;





CREATE TABLE `benches` (
  `benchid` int(11) NOT NULL auto_increment,
  `benchname` text NOT NULL,
  `benchcolor` text NOT NULL,
  `storeid` int(11) NOT NULL,
  UNIQUE KEY `benchid` (`benchid`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=latin1 AUTO_INCREMENT=8 ;

-- 
-- Dumping data for table `benches`
-- 

INSERT INTO `benches` (`benchid`, `benchname`, `benchcolor`, `storeid`) VALUES (1, 'North Bench', 'f6f6f6', 1),
(2, 'South Bench', 'd4d4ff', 1),
(3, 'Laptop Bench', 'fff4c6', 1),
(4, 'East Bench', 'b0ffa5', 1);



-- --------------------------------------------------------

-- 
-- Table structure for table `boxstyles`
-- 

CREATE TABLE `boxstyles` (
  `statusid` int(11) NOT NULL,
  `headerstyle` text NOT NULL,
  `bodystyle` text NOT NULL,
  `selectorcolor` text NOT NULL,
  `floaterstyle` text NOT NULL,
  `boxtitle` text NOT NULL,
  KEY `statusid` (`statusid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------


-- 
-- Dumping data for table `boxstyles`
-- 

INSERT INTO `boxstyles` (`statusid`, `headerstyle`, `bodystyle`, `selectorcolor`, `floaterstyle`, `boxtitle`) VALUES (2, 'background: #0000ff;\r\nborder-right: 2px solid #0000ff;\r\nborder-left: 2px solid #0000ff;\r\nborder-top: 2px solid #0000ff;\r\nborder-bottom: 1px solid #0000ff;\r\nbackground: -moz-linear-gradient(top, #6699FF 0%, #3366CC 50%, #003399 51%, #6699FF 100%); /* firefox */\r\nbackground: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#6699FF), color-stop(50%,#3366CC), color-stop(51%,#003399), color-stop(100%,#6699FF));\r\nbackground: -o-linear-gradient(top, #6699FF 0%,#3366CC 50%,#003399 51%,#6699FF 100%); /* Opera11.10+ */\r\nbackground: -ms-linear-gradient(top, #6699FF 0%,#3366CC 50%,#003399 51%,#6699FF 100%); /* IE10+ */\r\nbackground: linear-gradient(top, #6699FF 0%,#3366CC 50%,#003399 51%,#6699FF 100%); /* W3C */', 'border-right: 2px solid #0000ff;\r\nborder-left: 2px solid #0000ff;\r\nborder-bottom: 2px solid #0000ff;', '0000ff', 'background: #6699ff; /* Old browsers */\r\nbackground: -moz-linear-gradient(top,  #6699ff 0%, #003399 100%); /* FF3.6+ */\r\nbackground: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#6699ff), color-stop(100%,#003399)); /* Chrome,Safari4+ */\r\nbackground: -webkit-linear-gradient(top,  #6699ff 0%,#003399 100%); /* Chrome10+,Safari5.1+ */\r\nbackground: -o-linear-gradient(top,  #6699ff 0%,#003399 100%); /* Opera 11.10+ */\r\nbackground: -ms-linear-gradient(top,  #6699ff 0%,#003399 100%); /* IE10+ */\r\nbackground: linear-gradient(top,  #6699ff 0%,#003399 100%); /* W3C */\r\nborder: 2px solid #000022;', 'On the Bench'),
(52, 'background: #0000ff;\r\nborder-right: 2px solid #0000ff;\r\nborder-left: 2px solid #0000ff;\r\nborder-top: 2px solid #0000ff;\r\nborder-bottom: 1px solid #0000ff;\r\nbackground: -moz-linear-gradient(top, #6699FF 0%, #3366CC 50%, #003399 51%, #6699FF 100%); /* firefox */\r\nbackground: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#6699FF), color-stop(50%,#3366CC), color-stop(51%,#003399), color-stop(100%,#6699FF));\r\nbackground: -o-linear-gradient(top, #6699FF 0%,#3366CC 50%,#003399 51%,#6699FF 100%); /* Opera11.10+ */\r\nbackground: -ms-linear-gradient(top, #6699FF 0%,#3366CC 50%,#003399 51%,#6699FF 100%); /* IE10+ */\r\nbackground: linear-gradient(top, #6699FF 0%,#3366CC 50%,#003399 51%,#6699FF 100%); /* W3C */', 'border-right: 2px solid #0000ff;\r\nborder-left: 2px solid #0000ff;\r\nborder-bottom: 2px solid #0000ff;', '0000ff', '', 'Invoice List Box'),
(53, 'background: #aa0000;\r\nborder-right: 2px solid #aa0000;\r\nborder-left: 2px solid #aa0000;\r\nborder-top: 2px solid #aa0000;\r\nborder-bottom: 1px solid #aa0000;\r\nbackground: -moz-linear-gradient(top, #FF8282 0%, #D10000 50%, #AA0000 51%, #FF8282 100%); /* firefox *\r\nbackground: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#FF8282), color-stop(50%,#D10000), color-stop(51%,#AA0000), color-stop(100%,#FF8282));\r\nbackground: -o-linear-gradient(top, #FF8282 0%, #D10000 50%, #AA0000 51%, #FF8282 100%); /* Opera11.10+ */\r\nbackground: -ms-linear-gradient(top, #FF8282 0%, #D10000 50%, #AA0000 51%, #FF8282 100%); /* IE10+ */\r\nbackground: linear-gradient(top, #FF8282 0%, #D10000 50%, #AA0000 51%, #FF8282 100%); /* W3C */', 'border-right: 2px solid #aa0000;\r\nborder-left: 2px solid #aa0000;\r\nborder-bottom: 2px solid #aa0000;', 'aa0000', '', 'Overdue Invoice Box'),
(1, 'background: #000022;\r\nborder-right: 2px solid #000022;\r\nborder-left: 2px solid #000022;\r\nborder-top: 2px solid #000022;\r\nborder-bottom: 1px solid #000022;\r\nbackground: -moz-linear-gradient(top, #4669AF 0%, #1F3E7C 50%, #001644 51%, #4364A8 100%);\r\nbackground: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#4669AF), color-stop(50%,#1F3E7C), color-stop(51%,#001644), color-stop(100%,#4364A8));\r\nbackground: -o-linear-gradient(top, #4669AF 0%,#1F3E7C 50%,#001644 51%,#4364A8 100%); /* Opera11.10+ */\r\nbackground: -ms-linear-gradient(top, #4669AF 0%,#1F3E7C 50%,#001644 51%,#4364A8 100%); /* IE10+ */\r\nbackground: linear-gradient(top, #4669AF 0%,#1F3E7C 50%,#001644 51%,#4364A8 100%); /* W3C */', 'border-right: 2px solid #000022;\r\nborder-left: 2px solid #000022;\r\nborder-bottom: 2px solid #000022;', '000022', 'background: #4669AF; /* old browsers */\r\nbackground: -moz-linear-gradient(top, #4669AF 0%, #001644 100%); /* firefox */\r\nbackground: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#4669AF), color-stop(100%,#001644)); /* webkit */\r\nfilter: progid:DXImageTransform.Microsoft.gradient( startColorstr=''#4669AF'', endColorstr=''#001644'',GradientType=0 ); /* ie */\r\nbackground: -o-linear-gradient(top, #4669AF 0%, #001644 100%); /* Opera11.10+ */\r\nbackground: -ms-linear-gradient(top, #4669AF 0%, #001644 100%); /* IE10+ */\r\nbackground: linear-gradient(top, #4669AF 0%, #001644 100%); /* W3C */\r\nborder: 2px solid #000022;', 'Waiting for Bench'),
(3, 'background: #aa0000;\r\nborder-right: 2px solid #aa0000;\r\nborder-left: 2px solid #aa0000;\r\nborder-top: 2px solid #aa0000;\r\nborder-bottom: 1px solid #aa0000;\r\nbackground: -moz-linear-gradient(top, #FF8282 0%, #D10000 50%, #AA0000 51%, #FF8282 100%); /* firefox *\r\nbackground: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#FF8282), color-stop(50%,#D10000), color-stop(51%,#AA0000), color-stop(100%,#FF8282));\r\nbackground: -o-linear-gradient(top, #FF8282 0%, #D10000 50%, #AA0000 51%, #FF8282 100%); /* Opera11.10+ */\r\nbackground: -ms-linear-gradient(top, #FF8282 0%, #D10000 50%, #AA0000 51%, #FF8282 100%); /* IE10+ */\r\nbackground: linear-gradient(top, #FF8282 0%, #D10000 50%, #AA0000 51%, #FF8282 100%); /* W3C */', 'border-right: 2px solid #aa0000;\r\nborder-left: 2px solid #aa0000;\r\nborder-bottom: 2px solid #aa0000;', 'aa0000', 'background: #ff8282; /* Old browsers */\r\nbackground: -moz-linear-gradient(top,  #ff8282 0%, #aa0000 100%); /* FF3.6+ */\r\nbackground: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#ff8282), color-stop(100%,#aa0000)); /* Chrome,Safari4+ */\r\nbackground: -webkit-linear-gradient(top,  #ff8282 0%,#aa0000 100%); /* Chrome10+,Safari5.1+ */\r\nbackground: -o-linear-gradient(top,  #ff8282 0%,#aa0000 100%); /* Opera 11.10+ */\r\nbackground: -ms-linear-gradient(top,  #ff8282 0%,#aa0000 100%); /* IE10+ */\r\nbackground: linear-gradient(top,  #ff8282 0%,#aa0000 100%); /* W3C */\r\nborder: 2px solid #000022;', 'Pending / On Hold'),
(4, 'background: #006600;\r\nborder-right: 2px solid #006600;\r\nborder-left: 2px solid #006600;\r\nborder-top: 2px solid #006600;\r\nborder-bottom: 1px solid #006600;\r\nbackground: -moz-linear-gradient(top, #0FE500 0%, #009107 50%, #006006 51%, #0FE500 100%); \r\nbackground: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#0FE500), color-stop(50%,#009107), color-stop(51%,#006006), color-stop(100%,#0FE500)); /* webkit */\r\nbackground: -o-linear-gradient(top, #0FE500 0%, #009107 50%, #006006 51%, #0FE500 100%); /* Opera11.10+ */\r\nbackground: -ms-linear-gradient(top, #0FE500 0%, #009107 50%, #006006 51%, #0FE500 100%); /* IE10+ */\r\nbackground: linear-gradient(top, #0FE500 0%, #009107 50%, #006006 51%, #0FE500 100%); /* W3C */', 'border-right: 2px solid #06600;\r\nborder-left: 2px solid #006600;\r\nborder-bottom: 2px solid #006600;', '006600', 'background: #0fe500; /* Old browsers */\r\nbackground: -moz-linear-gradient(top,  #0fe500 0%, #006006 100%); /* FF3.6+ */\r\nbackground: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#0fe500), color-stop(100%,#006006)); /* Chrome,Safari4+ */\r\nbackground: -webkit-linear-gradient(top,  #0fe500 0%,#006006 100%); /* Chrome10+,Safari5.1+ */\r\nbackground: -o-linear-gradient(top,  #0fe500 0%,#006006 100%); /* Opera 11.10+ */\r\nbackground: -ms-linear-gradient(top,  #0fe500 0%,#006006 100%); /* IE10+ */\r\nbackground: linear-gradient(top,  #0fe500 0%,#006006 100%); /* W3C */\r\nborder: 2px solid #000022;', 'Completed/Ready for Pickup'),
(5, 'background: #aa0000;\r\nborder-right: 2px solid #aa0000;\r\nborder-left: 2px solid #aa0000;\r\nborder-top: 2px solid #aa0000;\r\nborder-bottom: 1px solid #aa0000;\r\nbackground: -moz-linear-gradient(top, #FF8282 0%, #D10000 50%, #AA0000 51%, #FF8282 100%); /* firefox *\r\nbackground: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#FF8282), color-stop(50%,#D10000), color-stop(51%,#AA0000), color-stop(100%,#FF8282));\r\nbackground: -o-linear-gradient(top, #FF8282 0%, #D10000 50%, #AA0000 51%, #FF8282 100%); /* Opera11.10+ */\r\nbackground: -ms-linear-gradient(top, #FF8282 0%, #D10000 50%, #AA0000 51%, #FF8282 100%); /* IE10+ */\r\nbackground: linear-gradient(top, #FF8282 0%, #D10000 50%, #AA0000 51%, #FF8282 100%); /* W3C */', 'border-right: 2px solid #aa0000;\r\nborder-left: 2px solid #aa0000;\r\nborder-bottom: 2px solid #aa0000;', 'aa0000', 'background: #ff8282; /* Old browsers */\r\nbackground: -moz-linear-gradient(top,  #ff8282 0%, #aa0000 100%); /* FF3.6+ */\r\nbackground: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#ff8282), color-stop(100%,#aa0000)); /* Chrome,Safari4+ */\r\nbackground: -webkit-linear-gradient(top,  #ff8282 0%,#aa0000 100%); /* Chrome10+,Safari5.1+ */\r\nbackground: -o-linear-gradient(top,  #ff8282 0%,#aa0000 100%); /* Opera 11.10+ */\r\nbackground: -ms-linear-gradient(top,  #ff8282 0%,#aa0000 100%); /* IE10+ */\r\nbackground: linear-gradient(top,  #ff8282 0%,#aa0000 100%); /* W3C */\r\nborder: 2px solid #000022;', 'Picked up by Customer'),
(6, 'background: #aa0000;\r\nborder-right: 2px solid #aa0000;\r\nborder-left: 2px solid #aa0000;\r\nborder-top: 2px solid #aa0000;\r\nborder-bottom: 1px solid #aa0000;\r\nbackground: -moz-linear-gradient(top, #FF8282 0%, #D10000 50%, #AA0000 51%, #FF8282 100%); /* firefox *\r\nbackground: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#FF8282), color-stop(50%,#D10000), color-stop(51%,#AA0000), color-stop(100%,#FF8282));\r\nbackground: -o-linear-gradient(top, #FF8282 0%, #D10000 50%, #AA0000 51%, #FF8282 100%); /* Opera11.10+ */\r\nbackground: -ms-linear-gradient(top, #FF8282 0%, #D10000 50%, #AA0000 51%, #FF8282 100%); /* IE10+ */\r\nbackground: linear-gradient(top, #FF8282 0%, #D10000 50%, #AA0000 51%, #FF8282 100%); /* W3C */', 'border-right: 2px solid #aa0000;\r\nborder-left: 2px solid #aa0000;\r\nborder-bottom: 2px solid #aa0000;', 'aa0000', 'background: #ff8282; /* Old browsers */\r\nbackground: -moz-linear-gradient(top,  #ff8282 0%, #aa0000 100%); /* FF3.6+ */\r\nbackground: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#ff8282), color-stop(100%,#aa0000)); /* Chrome,Safari4+ */\r\nbackground: -webkit-linear-gradient(top,  #ff8282 0%,#aa0000 100%); /* Chrome10+,Safari5.1+ */\r\nbackground: -o-linear-gradient(top,  #ff8282 0%,#aa0000 100%); /* Opera 11.10+ */\r\nbackground: -ms-linear-gradient(top,  #ff8282 0%,#aa0000 100%); /* IE10+ */\r\nbackground: linear-gradient(top,  #ff8282 0%,#aa0000 100%); /* W3C */\r\nborder: 2px solid #000022;', 'Waiting for Payment'),
(7, 'background: #b41cf4;\r\nborder-right: 2px solid #b41cf4;\r\nborder-left: 2px solid #b41cf4;\r\nborder-top: 2px solid #b41cf4;\r\nborder-bottom: 1px solid #b41cf4;\r\nbackground: -moz-linear-gradient(top, #D287F2 0%, #9818CE 50%, #8315B2 51%, #D287F2 100%); /* firefox */\r\nbackground: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#D287F2), color-stop(50%,#9818CE), color-stop(51%,#8315B2), color-stop(100%,#D287F2)); /* webkit */\r\nbackground: -o-linear-gradient(top, #D287F2 0%, #9818CE 50%, #8315B2 51%, #D287F2 100%); /* Opera11.10+ */\r\nbackground: -ms-linear-gradient(top, #D287F2 0%, #9818CE 50%, #8315B2 51%, #D287F2 100%); /* IE10+ */\r\nbackground: linear-gradient(top, #D287F2 0%, #9818CE 50%, #8315B2 51%, #D287F2 100%); /* W3C */', 'border-right: 2px solid #b41cf4;\r\nborder-left: 2px solid #b41cf4;\r\nborder-bottom: 2px solid #b41cf4;', 'b41cf4', 'background: #d287f2; /* Old browsers */\r\nbackground: -moz-linear-gradient(top,  #d287f2 0%, #8315b2 100%); /* FF3.6+ */\r\nbackground: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#d287f2), color-stop(100%,#8315b2)); /* Chrome,Safari4+ */\r\nbackground: -webkit-linear-gradient(top,  #d287f2 0%,#8315b2 100%); /* Chrome10+,Safari5.1+ */\r\nbackground: -o-linear-gradient(top,  #d287f2 0%,#8315b2 100%); /* Opera 11.10+ */\r\nbackground: -ms-linear-gradient(top,  #d287f2 0%,#8315b2 100%); /* IE10+ */\r\nbackground: linear-gradient(top,  #d287f2 0%,#8315b2 100%); /* W3C */\r\nborder: 2px solid #000022;', 'Ready to Sell'),
(8, 'background: #ff6600;\r\nborder-right: 2px solid #ff6600;\r\nborder-left: 2px solid #ff6600;\r\nborder-top: 2px solid #ff6600;\r\nborder-bottom: 1px solid #ff6600;\r\nbackground: -moz-linear-gradient(top, #FFCC00 0%, #FF9900 50%, #FF6600 51%, #FFCC00 100%); /* firefox */\r\nbackground: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#FFCC00), color-stop(50%,#FF9900), color-stop(51%,#FF6600), color-stop(100%,#FFCC00)); /* webkit */\r\nbackground: -o-linear-gradient(top, #FFCC00 0%, #FF9900 50%, #FF6600 51%, #FFCC00 100%); /* Opera11.10+ */\r\nbackground: -ms-linear-gradient(top, #FFCC00 0%, #FF9900 50%, #FF6600 51%, #FFCC00 100%); /* IE10+ */\r\nbackground: linear-gradient(top, #FFCC00 0%, #FF9900 50%, #FF6600 51%, #FFCC00 100%); /* W3C */', 'border-right: 2px solid #ff6600;\r\nborder-left: 2px solid #ff6600;\r\nborder-bottom: 2px solid #ff6600;', 'ff6600', 'background: #ffcc00; /* Old browsers */\r\nbackground: -moz-linear-gradient(top,  #ffcc00 0%, #ff6600 100%); /* FF3.6+ */\r\nbackground: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#ffcc00), color-stop(100%,#ff6600)); /* Chrome,Safari4+ */\r\nbackground: -webkit-linear-gradient(top,  #ffcc00 0%,#ff6600 100%); /* Chrome10+,Safari5.1+ */\r\nbackground: -o-linear-gradient(top,  #ffcc00 0%,#ff6600 100%); /* Opera 11.10+ */\r\nbackground: -ms-linear-gradient(top,  #ffcc00 0%,#ff6600 100%); /* IE10+ */\r\nbackground: linear-gradient(top,  #ffcc00 0%,#ff6600 100%); /* W3C */\r\nborder: 2px solid #000022;', 'On Service Call'),
(9, 'border-right: 2px solid #f30084;\r\nborder-left: 2px solid #f30084;\r\nborder-top: 2px solid #f30084;\r\nborder-bottom: 1px solid #f30084;\r\nbackground: #f30084;\r\nbackground: -moz-linear-gradient(top, #F29DCA 0%, #F248A3 50%, #CE006E 51%, #F29DCA 100%); /* firefox */\r\nbackground: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#F29DCA), color-stop(50%,#F248A3), color-stop(51%,#CE006E), color-stop(100%,#F29DCA));\r\nbackground: -o-linear-gradient(top, #F29DCA 0%, #F248A3 50%, #CE006E 51%, #F29DCA 100%); /* Opera11.10+ */\r\nbackground: -ms-linear-gradient(top, #F29DCA 0%, #F248A3 50%, #CE006E 51%, #F29DCA 100%); /* IE10+ */\r\nbackground: linear-gradient(top, #F29DCA 0%, #F248A3 50%, #CE006E 51%, #F29DCA 100%); /* W3C */', 'border-right: 2px solid #f30084;\r\nborder-left: 2px solid #f30084;\r\nborder-bottom: 2px solid #f30084;', 'f30084', 'background: #f29dca; /* Old browsers */\r\nbackground: -moz-linear-gradient(top,  #f29dca 0%, #ce006e 100%); /* FF3.6+ */\r\nbackground: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#f29dca), color-stop(100%,#ce006e)); /* Chrome,Safari4+ */\r\nbackground: -webkit-linear-gradient(top,  #f29dca 0%,#ce006e 100%); /* Chrome10+,Safari5.1+ */\r\nbackground: -o-linear-gradient(top,  #f29dca 0%,#ce006e 100%); /* Opera 11.10+ */\r\nbackground: -ms-linear-gradient(top,  #f29dca 0%,#ce006e 100%); /* IE10+ */\r\nbackground: linear-gradient(top,  #f29dca 0%,#ce006e 100%); /* W3C */\r\nborder: 2px solid #000022;', 'Remote Support Sessions'),
(50, 'border-top: 2px solid #000000;\r\nborder-left: 2px solid #000000;\r\nborder-right: 2px solid #000000;\r\nborder-bottom: 1px solid #000000;\r\nbackground: #333333; /* old browsers */\r\nbackground: -moz-linear-gradient(top, #A8A8A8 0%, #4F4F4F 50%, #232323 51%, #A8A8A8 100%);\r\nbackground: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#A8A8A8), color-stop(50%,#4F4F4F), color-stop(51%,#232323), color-stop(100%,#A8A8A8));\r\nbackground: -o-linear-gradient(top, #A8A8A8 0%,#4F4F4F 50%,#232323 51%,#A8A8A8 100%); /* Opera11.10+ */\r\nbackground: -ms-linear-gradient(top, #A8A8A8 0%,#4F4F4F 50%,#232323 51%,#A8A8A8 100%); /* IE10+ */\r\nbackground: linear-gradient(top, #A8A8A8 0%,#4F4F4F 50%,#232323 51%,#A8A8A8 100%); /* W3C */', 'border-right: 2px solid #000000;\r\nborder-left: 2px solid #000000;\r\nborder-bottom: 2px solid #000000;', '000000', '', 'Standard Title Boxes'),
(51, 'border-top: 2px solid #000000;\r\nborder-left: 2px solid #000000;\r\nborder-right: 2px solid #000000;\r\nborder-bottom: 1px solid #000000;\r\nbackground: #e0e0e0; /* Old browsers */\r\nbackground: -moz-linear-gradient(top,  #e0e0e0 0%, #939393 50%, #727272 52%, #aaaaaa 100%); /* FF3.6+ */\r\nbackground: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#e0e0e0), color-stop(50%,#939393), color-stop(52%,#727272), color-stop(100%,#aaaaaa)); /* Chrome,Safari4+ */\r\nbackground: -webkit-linear-gradient(top,  #e0e0e0 0%,#939393 50%,#727272 52%,#aaaaaa 100%); /* Chrome10+,Safari5.1+ */\r\nbackground: -o-linear-gradient(top,  #e0e0e0 0%,#939393 50%,#727272 52%,#aaaaaa 100%); /* Opera 11.10+ */\r\nbackground: -ms-linear-gradient(top,  #e0e0e0 0%,#939393 50%,#727272 52%,#aaaaaa 100%); /* IE10+ */\r\nbackground: linear-gradient(top,  #e0e0e0 0%,#939393 50%,#727272 52%,#aaaaaa 100%); /* W3C */', 'border-right: 2px solid #000000;\r\nborder-left: 2px solid #000000;\r\nborder-bottom: 2px solid #000000;', '000000', '', 'Remote Support Sessions'),
(0, 'border-right: 2px solid #88AA00;\r\nborder-left: 2px solid #88AA00;\r\nborder-top: 2px solid #88AA00;\r\nborder-bottom: 1px solid #88AA00;\r\nbackground: #88AA00;\r\nbackground: -moz-linear-gradient(top, #E4FFA8 0%, #96BC00 50%, #88AA00 51%, #E4FFA8 100%); /* firefox */\r\nbackground: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#E4FFA8), color-stop(50%,#96BC00),color-stop(51%,#88AA00), color-stop(100%,#E4FFA8)); /* webkit */\r\nbackground: -o-linear-gradient(top, #E4FFA8 0%, #96BC00 50%, #88AA00 51%, #E4FFA8 100%); /* Opera11.10+ */\r\nbackground: -ms-linear-gradient(top, #E4FFA8 0%, #96BC00 50%, #88AA00 51%, #E4FFA8 100%); /* IE10+ */\r\nbackground: linear-gradient(top, #E4FFA8 0%, #96BC00 50%, #88AA00 51%, #E4FFA8 100%); /* W3C */', 'border-right: 2px solid #88AA00;\r\nborder-left: 2px solid #88AA00;\r\nborder-bottom: 2px solid #88AA00;', '88AA00', '', '100');



-- 
-- Table structure for table `cart`
-- 

CREATE TABLE `cart` (
  `cart_item_id` int(11) NOT NULL auto_increment,
  `cart_price` float(11,2) NOT NULL default '0.00',
  `cart_type` text NOT NULL,
  `cart_stock_id` int(11) NOT NULL default '0',
  `labor_desc` text NOT NULL,
  `return_sold_id` int(11) NOT NULL default '0',
  `restocking_fee` text NOT NULL,
  `price_alt` int(11) NOT NULL default '0',
  `addtime` int(11) NOT NULL default '0',
  `ipofpc` text NOT NULL,
  `taxex` int(11) NOT NULL,
  `itemtax` decimal(11,2) NOT NULL,
  `origprice` decimal(11,2) NOT NULL,
  `discounttype` text NOT NULL,
  `ourprice` decimal(11,2) NOT NULL default '0.00',
  `itemserial` text NOT NULL,
  UNIQUE KEY `cart_item_id` (`cart_item_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


-- --------------------------------------------------------

-- 
-- Table structure for table `claimsigtext`
-- 

CREATE TABLE `claimsigtext` (
  `sigtextid` int(11) NOT NULL auto_increment,
  `sigtext` text NOT NULL,
  `woid` int(11) NOT NULL,
  PRIMARY KEY  (`sigtextid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


-- 
-- Table structure for table `commonproblems`
-- 

CREATE TABLE `commonproblems` (
  `probid` int(11) NOT NULL auto_increment,
  `theproblem` text NOT NULL,
  `custviewable` int(11) NOT NULL default '0',
  UNIQUE KEY `probid` (`probid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- 
-- Dumping data for table `commonproblems`
-- 

INSERT INTO `commonproblems` (`probid`, `theproblem`) VALUES (1, 'Virus/Rogue Cleaning'),
(3, 'Tuneup'),
(4, 'Backup Important Data First'),
(5, 'Reload Operating System'),
(6, 'Install New AntiVirus'),
(7, 'Internal Physical Cleaning'),
(8, 'Replace Bad Capacitors'),
(9, 'Computer does not Boot'),
(10, 'Computer does not power on'),
(11, 'Replace Bad LCD Screen'),
(15, 'Internet Doesn''t Work'),
(13, 'Computer has noisy fan'),
(16, 'Blue Screening'),
(17, 'Upgrade Memory');


-- --------------------------------------------------------

-- 
-- Table structure for table `currentcustomer`
-- 


CREATE TABLE `currentcustomer` (
  `cfirstname` text NOT NULL,
  `caddress` text NOT NULL,
  `caddress2` text NOT NULL,
  `ccity` text NOT NULL,
  `cstate` text NOT NULL,
  `czip` text NOT NULL,
  `cphone` text NOT NULL,
  `cemail` text NOT NULL,
  `byuser` text NOT NULL,
  `woid` int(11) NOT NULL,
  `invoiceid` int(11) NOT NULL,
  `pcgroupid` int(11) NOT NULL default '0',
  `rinvoiceid` int(11) NOT NULL default '0',
  `ccompany` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Table structure for table `currentpayments`
-- 

CREATE TABLE `currentpayments` (
  `paymentid` int(11) NOT NULL auto_increment,
  `pfirstname` text NOT NULL,
  `plastname` text NOT NULL,
  `paddress` text NOT NULL,
  `paddress2` text NOT NULL,
  `pcity` text NOT NULL,
  `pstate` text NOT NULL,
  `pzip` text NOT NULL,
  `pphone` text NOT NULL,
  `pemail` text NOT NULL,
  `byuser` text NOT NULL,
  `amount` decimal(11,2) NOT NULL,
  `paymentplugin` text NOT NULL,
  `cc_number` text NOT NULL,
  `cc_expmonth` int(11) NOT NULL,
  `cc_expyear` int(11) NOT NULL,
  `cc_transid` text NOT NULL,
  `cc_confirmation` text NOT NULL,
  `cc_cid` int(11) NOT NULL,
  `cc_track1` text NOT NULL,
  `cc_track2` text NOT NULL,
  `chk_dl` text NOT NULL,
  `chk_number` text NOT NULL,
  `paymentstatus` text NOT NULL,
  `paymenttype` text NOT NULL,
  `cc_cardtype` text NOT NULL,
  `custompaymentinfo` text NOT NULL,
  `isdeposit` int(11) NOT NULL default '0',
  `depositid` int(11) NOT NULL default '0',
  `pcompany` text NOT NULL,
  UNIQUE KEY `paymentid` (`paymentid`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=latin1 AUTO_INCREMENT=10 ;





-- 
-- Table structure for table `custsource`
-- 

CREATE TABLE `custsource` (
  `custsourceid` int(11) NOT NULL auto_increment,
  `thesource` text NOT NULL,
  `sourceenabled` int(11) NOT NULL default '1',
  `sourceicon` text NOT NULL,
  `showonreport` int(11) NOT NULL default '1',
  PRIMARY KEY  (`custsourceid`)
) ENGINE=MyISAM AUTO_INCREMENT=18 DEFAULT CHARSET=latin1 AUTO_INCREMENT=18 ;

-- 
-- Dumping data for table `custsource`
-- 

INSERT INTO `custsource` (`custsourceid`, `thesource`, `sourceenabled`, `sourceicon`, `showonreport`) VALUES (1, 'Yellow Pages', 1, 'yp.png', 1),
(2, 'Website', 1, 'www.png', 1),
(3, 'Unknown', 1, 'unknown.png', 0),
(4, 'Word of Mouth Refferal', 1, 'wordofmouth.png', 1),
(5, 'Billboard Advertising', 1, 'billboard.png', 1),
(6, 'Email or Mailed Newsletter', 1, 'emailornewsletter.png', 1),
(7, 'Social Network Refferal', 1, 'facebook.png', 1),
(8, 'Flyer', 1, 'flyer.png', 1),
(9, 'Google Adwords', 1, 'googleadwords.png', 1),
(10, 'Business Networking', 1, 'linkedin.png', 1),
(11, 'Phone Book', 1, 'phonebook.png', 1),
(12, 'Existing Customer', 1, 'regularcustomer.png', 0),
(13, 'Sponsorship Advertising', 1, 'sponsor.png', 1),
(14, 'Store Drive By', 1, 'storedriveby.png', 1),
(15, 'Newspaper Advertising ', 1, 'newspaper.png', 1);



-- --------------------------------------------------------

-- 
-- Table structure for table `deposits`
-- 

CREATE TABLE `deposits` (
  `depositid` int(11) NOT NULL auto_increment,
  `pfirstname` text NOT NULL,
  `plastname` text NOT NULL,
  `paddress` text NOT NULL,
  `paddress2` text NOT NULL,
  `pcity` text NOT NULL,
  `pstate` text NOT NULL,
  `pzip` text NOT NULL,
  `pphone` text NOT NULL,
  `pemail` text NOT NULL,
  `byuser` text NOT NULL,
  `amount` decimal(11,2) NOT NULL,
  `paymentplugin` text NOT NULL,
  `cc_number` text NOT NULL,
  `cc_expmonth` int(11) NOT NULL,
  `cc_expyear` int(11) NOT NULL,
  `cc_transid` text NOT NULL,
  `cc_confirmation` text NOT NULL,
  `cc_cid` int(11) NOT NULL,
  `cc_track1` text NOT NULL,
  `cc_track2` text NOT NULL,
  `chk_dl` text NOT NULL,
  `chk_number` text NOT NULL,
  `paymentstatus` text NOT NULL,
  `paymenttype` text NOT NULL,
  `cc_cardtype` text NOT NULL,
  `custompaymentinfo` text NOT NULL,
  `woid` int(11) NOT NULL,
  `receipt_id` int(11) NOT NULL,
  `dstatus` text NOT NULL,
  `depdate` datetime NOT NULL,
  `applieddate` datetime NOT NULL,
  `storeid` int(11) NOT NULL,
  `appliedstoreid` int(11) NOT NULL,
  `thesig` text NOT NULL,
  `showsigdep` int(11) NOT NULL default '1',
  `pcompany` text NOT NULL,
  UNIQUE KEY `depositid` (`depositid`)
) ENGINE=MyISAM AUTO_INCREMENT=1000 DEFAULT CHARSET=latin1 AUTO_INCREMENT=1000 ;



-- 
-- Table structure for table `frameit`
-- 

CREATE TABLE `frameit` (
  `frameitid` int(11) NOT NULL auto_increment,
  `frameitname` text NOT NULL,
  `frameiturl` text NOT NULL,
  UNIQUE KEY `frameitid` (`frameitid`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=latin1 AUTO_INCREMENT=15 ;

-- 
-- Dumping data for table `frameit`
-- 

INSERT INTO `frameit` (`frameitid`, `frameitname`, `frameiturl`) VALUES (6, 'Ninite', 'http://www.ninite.com'),
(12, 'Blacklist Check', 'http://www.mxtoolbox.com/blacklists.aspx'),
(11, 'Acer Support', 'http://support.acer.com/us/en/default.aspx'),
(7, 'Speedtest', 'http://www.speedtest.net'),
(8, 'Dell Warranty', 'http://support.dell.com/support/topics/global.aspx/support/my_systems_info/details'),
(9, 'HP Warranty', 'http://h10025.www1.hp.com/ewfrf/wc/weInput?cc=us&lc=en'),
(10, 'Toshiba Warranty', 'http://www.warranty.toshiba.com');



-- 
-- Table structure for table `inventory`
-- 

CREATE TABLE `inventory` (
  `inv_id` int(11) NOT NULL auto_increment,
  `stock_id` int(11) NOT NULL default '0',
  `inv_price` float(11,2) NOT NULL default '0.00',
  `inv_quantity` int(11) NOT NULL default '0',
  `inv_date` datetime NOT NULL default '0000-00-00 00:00:00',
  `storeid` int(11) NOT NULL,
  `itemserial` text NOT NULL,
  UNIQUE KEY `inv_id` (`inv_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- 
-- Dumping data for table `inventory`
-- 



CREATE TABLE `invoice_items` (
  `cart_item_id` int(11) NOT NULL auto_increment,
  `cart_price` float(11,2) NOT NULL default '0.00',
  `cart_type` text NOT NULL,
  `cart_stock_id` int(11) NOT NULL default '0',
  `labor_desc` text NOT NULL,
  `return_sold_id` int(11) NOT NULL default '0',
  `restocking_fee` text NOT NULL,
  `price_alt` int(11) NOT NULL default '0',
  `addtime` int(11) NOT NULL default '0',
  `invoice_id` int(11) NOT NULL,
  `taxex` int(11) NOT NULL default '0',
  `itemtax` decimal(11,2) NOT NULL default '0.00',
  `origprice` decimal(11,2) NOT NULL,
  `discounttype` text NOT NULL,
  `ourprice` decimal(11,2) NOT NULL default '0.00',
  `itemserial` text NOT NULL,
  UNIQUE KEY `cart_item_id` (`cart_item_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
-- --------------------------------------------------------

-- --------------------------------------------------------

-- 
-- Table structure for table `invoices`
-- 

CREATE TABLE `invoices` (
  `invoice_id` int(11) NOT NULL auto_increment,
  `invstatus` int(11) NOT NULL default '1',
  `invname` text NOT NULL,
  `invaddy1` text NOT NULL,
  `invaddy2` text NOT NULL,
  `invemail` text NOT NULL,
  `invphone` text NOT NULL,
  `invdate` datetime NOT NULL,
  `woid` int(11) NOT NULL default '0',
  `receipt_id` int(11) NOT NULL default '0',
  `invcity` text NOT NULL,
  `invstate` text NOT NULL,
  `invzip` text NOT NULL,
  `byuser` text NOT NULL,
  `preinvoice` int(11) NOT NULL default '0',
  `invnotes` text NOT NULL,
  `storeid` int(11) NOT NULL,
  `iorq` text NOT NULL,
  `rinvoice_id` int(11) NOT NULL default '0',
  `thesig` text NOT NULL,
  `showsiginv` int(11) NOT NULL default '1',
  `invcompany` text NOT NULL,
  KEY `invoice_id` (`invoice_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1000 DEFAULT CHARSET=latin1 AUTO_INCREMENT=1000 ;

-- --------------------------------------------------------

-- 
-- Table structure for table `maincats`
-- 

CREATE TABLE `maincats` (
  `cat_id` int(11) NOT NULL auto_increment,
  `cat_name` text NOT NULL,
  `cat_total_items` int(11) NOT NULL default '0',
  PRIMARY KEY  (`cat_id`)
) ENGINE=MyISAM AUTO_INCREMENT=21 DEFAULT CHARSET=latin1 AUTO_INCREMENT=21 ;

-- 
-- Dumping data for table `maincats`
-- 

INSERT INTO `maincats` (`cat_id`, `cat_name`, `cat_total_items`) VALUES (1, 'Drives', 0),
(2, 'Keyboards and Mice', 0),
(9, 'Sound', 0),
(4, 'Networking', 0),
(5, 'Digital Camera', 0),
(6, 'Video', 0),
(7, 'Gaming', 0),
(8, 'Cables and Adapters', 0),
(16, 'Printers and Scanners', 0),
(12, 'Misc', 0),
(11, 'Cases and Power Supplies', 0),
(15, 'Media', 0),
(17, 'CPU/Mainboard/RAM', 0),
(18, 'Software', 0),
(19, 'Computer Systems', 0),
(20, 'Consumer Electronics', 0);

-- --------------------------------------------------------

-- 
-- Table structure for table `onorder`
-- 

CREATE TABLE `onorder` (
  `ooid` int(11) NOT NULL auto_increment,
  `item` varchar(80) NOT NULL default '',
  `reason` varchar(80) NOT NULL default '',
  `notes` varchar(120) NOT NULL default '',
  UNIQUE KEY `ooid` (`ooid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- 
-- Dumping data for table `onorder`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `ordernumber`
-- 

CREATE TABLE `ordernumber` (
  `ordernumber` int(11) NOT NULL auto_increment,
  `placeholder` text NOT NULL,
  UNIQUE KEY `ordernumber` (`ordernumber`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;



-- --------------------------------------------------------

-- 
-- Table structure for table `pc_group`
-- 


CREATE TABLE `pc_group` (
  `pcgroupid` int(11) NOT NULL auto_increment,
  `pcgroupname` text NOT NULL,
  `grpphone` text NOT NULL,
  `grpcellphone` text NOT NULL,
  `grpworkphone` text NOT NULL,
  `grpemail` text NOT NULL,
  `grpaddress1` text NOT NULL,
  `grpaddress2` text NOT NULL,
  `grpcity` text NOT NULL,
  `grpstate` text NOT NULL,
  `grpzip` text NOT NULL,
  `grpprefcontact` text NOT NULL,
  `grpcustsourceid` int(11) NOT NULL,
  `grpnotes` text NOT NULL,
  `grpcompany` text NOT NULL,
  PRIMARY KEY  (`pcgroupid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;



-- --------------------------------------------------------

-- 
-- Table structure for table `pc_owner`
-- 

CREATE TABLE `pc_owner` (
  `pcid` int(11) NOT NULL auto_increment,
  `pcname` text NOT NULL,
  `pcphone` text NOT NULL,
  `pcmake` text NOT NULL,
  `pcemail` text NOT NULL,
  `pcaddress` text NOT NULL,
  `pcram` text NOT NULL,
  `pcproc` text NOT NULL,
  `pchd` text NOT NULL,
  `pccond` text NOT NULL,
  `pcserial` text NOT NULL,
  `pcaddress2` text NOT NULL,
  `pcstate` text NOT NULL,
  `pccity` text NOT NULL,
  `pczip` text NOT NULL,
  `pccellphone` text NOT NULL,
  `pcworkphone` text NOT NULL,
  `pcextra` text NOT NULL,
  `pcgroupid` int(11) NOT NULL default '0',
  `custsourceid` int(11) NOT NULL default '0',
  `prefcontact` text NOT NULL,
  `pcnotes` text NOT NULL,
  `pccompany` text NOT NULL,
  UNIQUE KEY `pcid` (`pcid`)
) ENGINE=MyISAM AUTO_INCREMENT=1000 DEFAULT CHARSET=latin1 AUTO_INCREMENT=1000 ;

-- --------------------------------------------------------

-- 
-- Table structure for table `pc_scan`
-- 

CREATE TABLE `pc_scan` (
  `scanid` int(11) NOT NULL auto_increment,
  `scantype` int(11) NOT NULL default '0',
  `scannum` int(11) NOT NULL default '0',
  `woid` int(11) NOT NULL default '0',
  `scantime` datetime NOT NULL default '0000-00-00 00:00:00',
  `customprogname` text NOT NULL,
  `customprogword` text NOT NULL,
  `customprintinfo` text NOT NULL,
  `customscantype` int(11) NOT NULL default '100',
  `byuser` text NOT NULL,
  PRIMARY KEY  (`scanid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


-- --------------------------------------------------------

-- 
-- Table structure for table `pc_scans`
-- 

CREATE TABLE `pc_scans` (
  `scanid` int(11) NOT NULL auto_increment,
  `progname` text NOT NULL,
  `progword` text NOT NULL,
  `progicon` text NOT NULL,
  `hasinfo` int(11) NOT NULL default '0',
  `printinfo` text NOT NULL,
  `theorder` int(11) NOT NULL default '0',
  `scantype` int(11) NOT NULL default '0',
  `active` int(11) NOT NULL default '1',
  PRIMARY KEY  (`scanid`)
) ENGINE=MyISAM AUTO_INCREMENT=74 DEFAULT CHARSET=latin1 AUTO_INCREMENT=74 ;

-- 
-- Dumping data for table `pc_scans`
-- 

INSERT INTO `pc_scans` (`scanid`, `progname`, `progword`, `progicon`, `hasinfo`, `printinfo`, `theorder`, `scantype`, `active`) VALUES (1, 'Ad-Aware Scan', 'Spyware scan', 'adaware.png', 0, '', 5, 0, 1),
(2, 'AVG Anti-VIRUS Scan', 'Virus Scan', 'avg.png', 0, '', 10, 0, 1),
(3, 'Spybot Scan', 'Spyware Scan', '3l_spybot.png', 0, '', 5, 0, 1),
(4, 'Defrag', 'Defragmented Hard Drive', 'defrag.png', 1, 'When a computer saves files on your computer, it looks for the first available space on the hard drive to put it. Many times files are save in many small open areas instead of one big open area. Defragging moves files that are split up all over the place and puts them all in one place on the hard drive which increases the performance of loading these files.', 10, 1, 1),
(5, 'Cleaned Temp Folders', 'Cleaned Temp Folders', 'tempclean.png', 1, 'Many programs leave various temporary use files laying around the computer which never get used again and just take up space. We cleaned all these from your computer.', 10, 1, 1),
(6, 'Hi-Jack This Scan', 'Browser Hi-Jacks Removed', 'hijack.png', 0, '', 8, 0, 1),
(7, 'CHKDSK', 'Thorough Hard Disk Check', 'hd.png', 1, 'We ran a special program that checks all the files and the filesystem on your computer and repairs them if problems are found. This check also identifies bad hard drive sectors and marks them so that the computer will no longer try to use them.', 3, 1, 1),
(8, 'SCANDISK', 'Thorough Hard Disk Check', 'hd.png', 1, 'We ran a special program that checks all the files and the filesystem on your computer and repairs them if problems are found. This check also identifies bad hard drive sectors and marks them so that the computer will no longer try to use them.', -1, 1, 0),
(9, 'Avira Scan', 'Virus Scan', 'freeav.png', 0, '', 3, 0, 0),
(10, 'Verified Dial-up Settings', 'Verified Dial-up Settings', 'dialup.png', 1, 'Your computer was checked or set-up for dialup internet service.', 1, 1, 1),
(11, 'Firefox', 'Installed or Updated Firefox', '11l_firefox.png', 1, 'Mozilla Firefox is a web browser alternative to Microsoft Internet Explorer. It can do everything that Internet Explorer can do. The more you use Firefox and the less you use Internet Explorer, the less likely you are to get viruses and spyware. One other advantage is due to the fact that Firefox is not tied to the Windows Operating System like Internet Explorer is, problems with Firefox won''t effect your whole computer like what happens often with Internet Explorer. ', 8, 2, 1),
(12, 'OpenOffice', 'Installed or Updated OpenOffice', 'openoffice.png', 1, 'OpenOffice.org is a free Office Suite comparable to Microsoft Office. It offers a spreadsheet, word processing, presentations, and more as well as the ability to read Microsoft Office documents. Why spend $150 plus for Microsoft Office? Anyone can download this software for free @ <u>www.openoffice.org</u>', 8, 2, 1),
(13, 'Thunderbird', 'Installed or Updated Thunderbird', 'thunderbird.png', 1, 'Thunderbird is an email program that can be used as an alternative to Outlook Express on Windows XP or Windows Mail on Vista. It also has many features not found Outlook Express such as powerful spam filtering. Thunderbird is also a great email program for Windows 7 users now that Microsoft has no longer includes an email program on Windows 7.', 0, 2, 1),
(14, 'Windows Updates', 'Installed Windows Updates', 'updates.png', 1, 'Your computer had all the necessary updates from Microsoft installed. Installing updates keeps your computer running faster, adds new features, fixes software glitches and helps protect your computer from getting infected by viruses.', 10, 1, 1),
(15, 'Windows Defender Scan', 'Spyware Scan', 'windowsdefender.png', 0, '', 3, 0, 0),
(16, 'Backed up Hard Drive', 'Backed up Hard Drive', 'backup.png', 1, 'Your computer hard drive data was backed up.', 2, 1, 1),
(18, 'Spybot', 'Installed or Updated Spybot Search and Destroy', '18l_spybot.png', 1, 'Spybot Search and Destroy is a great program for scanning and removing spyware from your computer. It also includes an immunization feature that blocks known websites that distribute spyware.', 0, 2, 1),
(19, 'AVG Anti-Virus', 'Installed or Updated AVG Anti-Virus', 'avg.png', 1, 'AVG Anti-Virus Free Edition is a better performing free anti-virus and anti-spyware program. It also provides real-time virus protection. It also automatically keeps itself updated. It uses much less memory, scans faster and it doesn''t bog your computer down like many alternatives. They also offer paid versions of the program, but the free version does everything you need. About once a year they release a new Free version that you must manually upgrade to.', 10, 2, 1),
(17, 'Ad-Aware', 'Installed or Updated Ad-Aware', 'adaware.png', 1, 'Ad-Aware is a free program that removes spyware from your computer. It must be manually run to check for spyware.', 0, 2, 1),
(20, 'Panda Anti-Virus Scan', 'Virus Scan', 'panda.png', 0, '', 3, 0, 0),
(21, 'Trendmicro AV Scan', 'Virus Scan', 'trend.png', 0, '', 4, 0, 1),
(22, 'Crap Cleaner', 'Invalid Registry Entries', 'ccleaner.png', 0, '', 8, 0, 1),
(23, 'Ran CD Lens Cleaner', 'Cleaned CD/DVD Laser Lens', 'cdrom.png', 1, 'We ran a cleaner disc on your computers cd or dvd drive which cleans the dust off of the laser lense helping reduce skips and lower performance problems.', 0, 1, 1),
(24, 'Blew Dust out of Case', 'Cleaned Dust from inside PC Case', 'caseclean.png', 1, 'We blew the dust and dirt out of your computer. Dust buildup in a computer can cause overheating can and very often does cause permanent damage to your computer.', 10, 1, 1),
(25, 'Windows Defender', 'Installed or Updated Microsoft Windows Defender', 'windowsdefender.png', 1, 'Microsoft Windows Defender is a free program that removes spyware from your computer. It provides a realtime protection against spyware. ', -1, 2, 0),
(26, 'Avira', 'Installed or Updated Avira', 'freeav.png', 1, 'Avira is a great virus scanner that works very well on older computers and/or slower computers.', -1, 2, 0),
(27, 'F-Secure AV Scan', 'Virus Scan', 'fprot.png', 0, '', 4, 0, 1),
(28, 'Comp Assoc AV Scan', 'Virus Scan', 'ca.png', 0, '', 4, 0, 1),
(29, 'Bit Defender AV Scan', 'Virus Scan', 'bitdefender.png', 0, '', 4, 0, 1),
(30, 'Computer Full Of Dust', 'Computer Full Of Dust', 'caseclean.png', 1, 'Computer was found to be full of dust. Excess dust can lead to overheating, computer instability, and or damage to your computer system. Dust also is the number one  cause of defective or poorly performing CD/DVD ROM drives and floppy drives. We highly recommend blowing the dust out of your computer case with canned dry air at least every 6 months. Keeping computers off of the floor can also help reduce the amount of dust in a computer system due to the fact that when people walk around thier feet kick up alot of dust that ends up sucked into the tower.', 4, 3, 1),
(31, 'XP &lt; 256MB of RAM', 'XP &lt; 256MB of RAM', 'memory.png', 1, 'You system runs Windows XP and has less than 256MB of memory. While Microsoft recommends a bear minimum of 128MB of memory, most Windows XP Machines use almost 128MB of RAM with out any other programs open. Your systems performance would be noticably increased by adding more memory. Ask us for details!', -1, 3, 0),
(32, 'Bad Sectors found on HD', 'Bad Sectors found on Hard Drive', 'hd.png', 1, 'Bad sectors were found on your hard drive. These sectors were marked as bad so that your computer will no longer attempt to use them. While many computers operate fine after discovering bad sectors, this could be a sign of an impending Hard Drive failure. Extra care should be taken to backup important documents and files. If your hard drive fails, everything on the computer will be lost. ', 4, 3, 1),
(33, 'Poor Modem Performance', 'Poor Modem Performance', 'dialup.png', 1, 'Your modem performed at a speed lower than the typical speed we see from average computers. You may also experience disconnects more frequently than most. While you modem will still work, increased speed and reliabilty could be acheived by replacing the modem in your computer.  ', 4, 3, 1),
(34, 'Rogue (Fake) AV Programs Removed', 'Rogue (Fake) AV Programs Removed', 'rogue.png', 1, '<table width=100% border=1 cellspacing=0 bordercolor=#000000><tr><td>\r\n<br><center>\r\n<b><font size=2>Rogue (Fake) Anti-Virus Software: How to Spot It & Avoid It!</font></b><br><br>\r\n<img src=/repair/images/rogue2.gif><br><br>\r\n</center>\r\n<font size=2>\r\nHave you seen this advertisement or similar pop-up messages?  A free PC scan or an offer to clean your computer of supposedly infected files are often attempts by malevolent persons or organizations to install malicious software (malware) such as a Trojan horse, keylogger, or spyware. Such software is referred to as rogue (fake) anti-virus malware.\r\n<br><br>\r\n<b>How can my system get infected?</b><br>\r\nThe primary way rogue anti-virus software gets on your system is the result of you clicking on a malicious link in an advertisement or similar pop-up message.  The wording contained in the advertisement is usually something alarming, designed to get your attention and attempt to convince to you scan your PC or clean it immediately with the offered tool.  The names of the fake programs sound legitimate, and often, in a further attempt to make the malware appear legitimate, the programs may prompt you to pay for an annual subscription to the service. \r\n<br><br>\r\nAny kind of website could host ads for rogue anti-virus: news sites, sports pages, and social networking sites as well as "riskier" sites such as hacker blogs.  Some varieties of rogue anti-virus programs will also get installed on your machine just by you visiting a website with a malicious ad or code, and you might never know you''ve been impacted. \r\n<br><br>\r\n<b>Won''t my valid anti-virus and anti-spyware program protect my computer?</b><br>\r\nThough good anti-virus and anti-spyware programs will protect against many threats, they cannot protect against all malware threats, especially the newest ones.  There are millions of different versions of malware, with hundreds more being created and used every day.  It may take a day, a week, or even longer for anti-virus companies to develop and distribute an update to detect and clean the newest malware. Also nowadays many malwares install a piece of software known as a rootkit, which will hide the viruses from your antivirus software, which will keep itself from being detected.\r\n<br><br>\r\n<b>What can rogue anti-virus software do to my computer?</b><br>\r\nJust about anything,   Rogue anti-virus software might perform many activities, including installing files to monitor your computer use or steal credentials, installing backdoor programs, or adding your computer to a zombie botnet.  The malware might even use your computer as a vehicle for compromising other systems in your home or workplace network.\r\n<br><br>\r\nRogue anti-virus software can also modify systems files and registry entries so that even when you clean off some infected files or registry keys others might remain, or even allow the infections to be restored and active again after your system is rebooted.  For example, one recent rogue anti-virus program reportedly installed several malicious Trojan files, and also made over two-dozen different changes to ensure that the malware stayed on the system and stayed running.  This type of malware also often blocks access to valid security sites (anti-virus and anti-spyware companies, and operating system and application update sites) so that you won''t be able to patch or clean your system by visiting those valid sites.\r\n<br><br>\r\n<b>What can I do to protect my computer?</b><br>\r\n<ol>\r\n<li>Don''t click on pop-up ads that advertise anti-virus or anti-spyware programs.  Even though pop-up ads are used for valid advertising they can also be used for malicious purposes, like getting you to install fake security programs.  If you are interested in a security product, search for it and visit its homepage, don''t get to it through a pop-up ad.\r\n<li>If you become trapped in a webpage or pop-up that is trying to force you into accepting or downloading something just turn the computer off or restart the computer. Don''t click OK hoping that you will be able to click no later, it will be too late.\r\n<li>Use and regularly update firewalls, anti-virus, and anti-spyware programs.  It is very important to use and keep these programs updated regularly so they can protect your computer against the most recent threats.  If possible, update them automatically and at least daily.\r\n<li>Properly update operating systems, browsers, and other software programs.  Keep your system and programs updated and patched so that your computer will not be exposed to known vulnerabilities and attacks.\r\n<li>Keep backups of important files.  Sometimes cleaning infections can be very easy; sometimes they can be very difficult.  You may find that an infection has affected your computer so much that the operating system and applications need to be reinstalled.  In cases like this, it is best to have your important data backed up already so you can restore your system without fear of losing your data.\r\n<li>Regularly scan and clean your computer.  If your organization already has configured this on your computer, do not disable it.  If you need to scan your computer yourself, schedule regular scans in your programs.  Also, several trusted anti-virus and anti-spyware vendors offer free scans and cleaning.  Access these types of services from reputable companies and from their webpage, not from an unexpected pop-up.\r\n</ol>\r\n</font>\r\n</td></tr>\r\n</table>', 10, 1, 1),
(35, 'Windows Failed to Validate', 'Windows Failed to Validate', 'pirated.png', 1, 'Upon attempting to perform Windows Updates, your computer failed to validate as Genuine Authentic Windows. This is usually a sign that the product key used to install Windows was not valid. In order to resolve this issue you must contact Microsoft for a valid product key or purchase a new legal copy of Microsoft Windows. Microsoft does not allow Windows Updates to be performed on computers that do not pass validation, which can leave you more vulnerable to Spyware and Viruses', 4, 3, 1),
(36, 'CD/DVD Rom Defective/Poor Performance', 'CD/DVD Rom Defective/Poor Performance', 'cdrom.png', 1, 'Your CD/DVD-ROM drive was found to be performing poorly or not at all. Dust is usually the number one cause of all Optical Drive failures. This problem may prevent you from being able to load software onto your computer.', 4, 3, 1),
(37, 'Insufficient Memory', 'Insufficient Memory', 'memory.png', 1, 'Your system was found to be using more Memory than is currently installed. When this happens, your Hard Drive is used as temporary memory which can result in poor, lagging performance. Upgrading the memory in your computer would provide a noticable speed increase.', 1, 3, 1),
(38, 'Norton, Trend Micro or McAfee Antivirus still Installed', 'Norton, Trend Micro or McAfee Antivirus still Installed', 'slow.png', 1, 'Your system was found has either Norton, Trend Micro or McAfee installed. These programs are known for their poor performance. They use excessive amounts of memory compared to other alternatives slowing your computer down. They quite often are unable to remove viruses that are loaded into memory.  The also many times come with firewalls that go haywire and prevent you from getting online. Why pay for these programs when there are free alternatives available that just work better?', 1, 3, 1),
(39, 'Norton, Trend Micro or McAfee Antivirus Removed', 'Norton, Trend Micro or McAfee Antivirus Removed', 'nortonmcafee.png', 1, 'Your system was found to have out-of-date or corrupted installations of either Norton, Trend Micro or McAfee Anti-Virus.  These programs are known for their poor performance. They use excessive amounts of memory compared to other alternatives slowing your computer down. They quite often are unable to remove viruses that are loaded into memory.  Why pay for these programs when there are free alternatives available that just work better? For these reasons we have removed these anti-virus programs and replaced them with free, better performing alternatives.', 1, 1, 1),
(40, 'Operating System Reloaded', 'Operating System Reloaded', 'hd2.png', 1, 'The Operating System on your computer was reloaded. This means that everything was wiped from the Hard Drive and the Operating System was freshly installed. Any software, printers, or other devices that you had added since buying the computer will need to be re-installed.', 10, 1, 1),
(41, 'Operating System Reloaded w/Backup', 'Operating System Reloaded w/Backup', 'hd2.png', 1, 'The Operating System on your computer was reloaded. This means that everything was wiped from the Hard Drive and the Operating System was freshly installed. Any software, printers, or other devices that you had added since buying the computer will need to be re-installed.\r\n<br><br>\r\nWe also backed up all or part of the files on your Hard Drive before reloading your computer. These backup files are located on the Desktop in a folder named Backup. While it is generally not possible to recover programs from this backup, your documents and data will be accessible once the corresponding program has been re-installed on your computer.\r\n', 10, 1, 1),
(42, 'Hard Drive Low on Space', 'Hard Drive Low on Space', 'hd.png', 1, 'Your hard disk drive was found to be low on disk space. Low hard disk drive space can result in slow performance, instability, and preventing you from loading new software programs. The solution is to add more space by either adding or replacing the hard drive, or removing programs that you no longer use from the computer. You can use the <i>Add/Remove Programs</i> icon in the control panel to remove unused programs. Be careful to only remove programs you are positive are no longer needed.', 5, 3, 1),
(45, 'AVG Anti-SPYWARE Scan', 'Spyware scan', 'avg.png', 0, '', 3, 0, 0),
(46, 'Operating System Reloaded  (Non Destructive)', 'Operating System Reload (Non Destructive)', 'hd2.png', 1, 'The Operating System on your computer was reloaded over top of the old Operating system leaving your files and the majority of your settings intact. This type of reload is usually the last thing we can do to fix operating system problems without wiping the hard drive completely empty and reloading Windows.', 10, 1, 1),
(47, 'CCleaner', 'Installed or Updated CCleaner', 'ccleaner.png', 1, 'CCleaner, short for Crap Cleaner, provides and easy 1 click way to clean your system of temp files, tracking cookies and temporary Internet files. It also supports removing stale Windows registry entries.', 9, 2, 1),
(48, 'Performance Note: AOL Client Software', 'Performance Note: AOL Client Software', 'aol.png', 1, 'Your system was found to have the AOL client software installed. AOL uses alot of system memory. System performance can be increased by removing AOL if you no longer use it. AOL can be safely removed by using the <b>Add/Remove Programs</b> feature in the Windows Control Panel. This is not to be confused with the AOL instant messanger known as AIM which is fine.', 0, 3, 1),
(49, 'Performance Note: Kodak Easy Share', 'Performance Note: Kodak Easy Share', 'kodak.png', 1, 'Your system was found to have the Kodak Easyshare Digital Camera software installed. Easyshare uses alot of system memory. System performance can be increased by removing Easyshare if you no longer use it or no longer own a Kodak digital camera. Easyshare can be safely removed by using the <b>Add/Remove Programs</b> feature in the Windows Control Panel. ', 0, 3, 1),
(50, 'Performance Note: AT&T Yahoo Client Software', 'Performance Note: AT&T Yahoo Client Software', 'att.png', 1, 'Your system was found to have the ATT Yahoo client software installed. The ATT/Yahoo software uses alot of system memory. Especially if you use their online protection software which is just rebranded inferior software made by a 3rd party company. System performance can be increased by removing the ATT/Yahoo software if you no longer use the ATT/Yahoo internet service. This software can be safely removed by using the <b>Add/Remove Programs</b> feature in the Windows Control Panel. ', 0, 3, 1),
(51, 'Computer has Windows 98/ME ', 'Computer has Windows 95/98/ME/2000 ', 'windows98.png', 1, 'Your computer is running the Microsoft Windows 98, 2000, or ME operating system. These operating systems are no longer supported by Microsoft as of July of 2006. What this means is that newly released software is no longer guaranteed to work on your computer. It also means that Microsoft will no longer fix bugs and other security problems with the operating system on your computer, which means your system will be more susceptible to viruses and spyware. Also you can no longer buy a new off the shelf printer that will work with it. Many other newer hardware and software items will no longer work with it.\r\n\r\nIt may be possible to upgrade your system to a newer version of Windows, but it is probably more wise to consider shopping for a newer computer.', 1, 3, 1),
(52, 'Spyware Doctor Scan', 'Spyware scan', 'spywaredoctor.png', 0, '', 8, 0, 1),
(53, 'Adobe Acrobat', 'Installed or Updated Adobe Acrobat Reader', 'adobe.png', 1, 'Adobe Acrobat is a program to read PDF files that are commonly used on the Internet for documents.', 6, 2, 1),
(54, 'Java', 'Installed or Updated Java', 'java.png', 1, 'Java is a system commonly used to power websites like Pogo and Yahoo games.', 6, 2, 1),
(73, 'Google Chrome', 'Google Chrome', '73google-chrome-icon.png', 1, 'Google Chrome is a browser that combines a minimal design with sophisticated technology to make the web faster, safer, and easier.', 1, 2, 1),
(58, 'MS Security Essentials Scan', 'Malware scan', 'mse.png', 0, '', 7, 0, 1),
(59, 'Memory Tested', 'Memory passed thorough test', 'memory.png', 1, 'The memory or RAM in your computer was tested with a very extensive test to make sure it is free from defect. Bad memory can cause random crashes. Your computer passed these tests.', 3, 1, 1),
(60, 'Hard Drive Tested', 'Hard Drive passed thorough test', 'hd2.png', 1, 'The hard drive in your computer received a thorough physical test and passed the test. Quite often this test can detect hard drive problems before they happen. When hard drives go bad, many times everything save on the computer is lost.', 3, 1, 1),
(61, 'Risky File Sharing Programs Found', 'Risky File Sharing Programs Found', 'limewire.png', 1, 'Filesharing programs such as Limewire, Frostwire, or Bit Torrent, were found on your computer. While these types of things are popular on the Internet because the facilitate the free downloading of copyrighted music, videos, and software, they are also a large source of Viruses and other Malware. These free downloads can become very expensive when what you think is a free program or song ends up being a virus that damages your computer or steals private information like passwords or other confidential information. Illegal downloading of copyrighted works can also result in legal action against you if you are caught.', 10, 3, 1),
(62, 'Microsoft Security Essentials', 'Installed or Updated Microsoft Security Essentials', 'mse.png', 1, 'Microsoft Security Essentials is a free Anti-Virus and Anti Spyware program from Microsoft that is very lightweight and works great on computers with lower amounts of memory. ', 9, 2, 1),
(63, 'Manually Removed Viruses', 'Manually Removed Viruses', 'hand.png', 0, '', 12, 0, 1),
(64, 'Malwarebytes Scan', 'Spyware Scan', 'malwarebytes.png', 0, '', 5, 0, 1),
(65, 'Hot Running Laptop', 'Hot Running Laptop', 'hottop.png', 1, 'Your laptop runs very hot. We highly recommend blowing the dust out of the fan vent every 3 months. We also highly recommend purchasing a laptop cooling pad. A laptop cooling pad costs less then $30 and can help prevent premature failure.', 4, 3, 1),
(66, 'Upgraded Internet Explorer', 'Upgraded Internet Explorer', 'ie.png', 1, 'We upgraded the Internet Explorer browser on your computer to the latest version.', 1, 1, 1),
(67, 'PC Decrapifier', 'Cleaned Out Trialware', 'decrap.png', 1, 'Most computers when purchased new are loaded full of trialware, Toolbars, advertising and Internet offers, and other worthless crap. We removed this junk from you computer which helps it run faster and be less cluttered.', 3, 1, 1),
(68, 'Viruses & Spyware Removed', 'Viruses & Spyware Removed', 'virus.png', 1, 'Your computer was cleaned of all know viruses, spyware and other malware which can cause lockups, slowness, information stolen from your computer, the ability of a hacker to use your computer in a botnet to attack or spam other computers on the Internet and other problems.', 1, 1, 1),
(69, 'PC Decrapifier', 'Trialware & Preloaded Junk', 'decrap.png', 0, '', 5, 0, 1),
(70, 'Eset Nod32 Antivirus', 'Virus Scan', 'eset.png', 0, '', 4, 0, 1),
(72, 'CD Burner XP Pro', 'CD Burner XP Pro', '72cdburnerxppro.png', 1, 'CD Burner XP Pro is a great free program for burning Data and Audio CD''s', 0, 2, 1);


-- --------------------------------------------------------

-- 
-- Table structure for table `pc_wo`
-- 

CREATE TABLE `pc_wo` (
  `woid` int(11) NOT NULL auto_increment,
  `pcid` int(11) NOT NULL default '0',
  `probdesc` text NOT NULL,
  `virusesfound` text NOT NULL,
  `custnotes` text NOT NULL,
  `technotes` text NOT NULL,
  `dropdate` datetime NOT NULL default '0000-00-00 00:00:00',
  `pickupdate` datetime NOT NULL default '0000-00-00 00:00:00',
  `readydate` datetime NOT NULL default '0000-00-00 00:00:00',
  `pcstatus` int(11) NOT NULL default '0',
  `called` int(11) NOT NULL default '1',
  `thepass` text NOT NULL,
  `custassets` text NOT NULL,
  `bench` int(11) NOT NULL,
  `workarea` text NOT NULL,
  `pcpriority` text NOT NULL,
  `cibyuser` text NOT NULL,
  `notesbyuser` text NOT NULL,
  `cobyuser` text NOT NULL,
  `commonproblems` text NOT NULL,
  `storeid` int(11) NOT NULL,
  `thesig` text NOT NULL,
  `thesigwo` text NOT NULL,
  `assigneduser` text NOT NULL,
  `showsigct` int(11) NOT NULL default '1',
  `showsigrr` int(11) NOT NULL default '1',
  PRIMARY KEY  (`woid`)
) ENGINE=MyISAM AUTO_INCREMENT=1000 DEFAULT CHARSET=latin1 AUTO_INCREMENT=1000 ;

-- 
-- Table structure for table `photos`
-- 

CREATE TABLE `photos` (
  `photo_id` int(11) NOT NULL auto_increment,
  `photo_filename` text NOT NULL,
  `stock_item` int(11) NOT NULL default '0',
  UNIQUE KEY `photo_id` (`photo_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- 
-- Dumping data for table `photos`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `quicklabor`
-- 

CREATE TABLE `quicklabor` (
  `quickid` int(11) NOT NULL auto_increment,
  `labordesc` text NOT NULL,
  `laborprice` decimal(11,2) NOT NULL default '0.00',
  `theorder` int(11) NOT NULL default '0',
  PRIMARY KEY  (`quickid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
-- 
-- Dumping data for table `quicklabor`
-- 

INSERT INTO `quicklabor` (`quickid`, `labordesc`, `laborprice`) VALUES (1, 'Virus/Spyware Removal', 100),
(2, 'Operating System Reload', 300),
(3, 'Data Backup', 75),
(4, 'Minimum Bench Fee', 35),
(5, 'Tune up/Bench Fee', 60),
(6, 'Tune up/Bench Fee', 35),
(7, 'Component Install', 250),
(8, 'Install CD-ROM', 100);

-- --------------------------------------------------------
-- --------------------------------------------------------

-- 
-- Table structure for table `receipts`
-- 

CREATE TABLE `receipts` (
  `receipt_id` int(11) NOT NULL auto_increment,
  `pay_type` text NOT NULL,
  `person_name` text NOT NULL,
  `address1` text NOT NULL,
  `address2` text NOT NULL,
  `phone_number` text NOT NULL,
  `ccnumber` text NOT NULL,
  `ccexpdate` text NOT NULL,
  `driverslc` text NOT NULL,
  `check_number` text NOT NULL,
  `grandtotal` float(11,2) NOT NULL default '0.00',
  `date_sold` datetime NOT NULL default '0000-00-00 00:00:00',
  `grandtax` float(11,2) NOT NULL default '0.00',
  `paywith` text NOT NULL,
  `taxex` int(11) NOT NULL default '1',
  `transid` text NOT NULL,
  `confirmation` text NOT NULL,
  `byuser` text NOT NULL,
  `city` text NOT NULL,
  `state` text NOT NULL,
  `zip` text NOT NULL,
  `email` text NOT NULL,
  `woid` text NOT NULL,
  `invoice_id` text NOT NULL,
  `storeid` int(11) NOT NULL,
  `thesig` text NOT NULL,
  `showsigrec` int(11) NOT NULL default '1',
  `company` text NOT NULL,
  UNIQUE KEY `receipt_id` (`receipt_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1000 DEFAULT CHARSET=latin1 AUTO_INCREMENT=1000 ;

-- --------------------------------------------------------

-- 
-- Table structure for table `repaircart`
-- 

CREATE TABLE `repaircart` (
  `cart_item_id` int(11) NOT NULL auto_increment,
  `cart_price` float(11,2) NOT NULL default '0.00',
  `cart_type` text NOT NULL,
  `cart_stock_id` int(11) NOT NULL default '0',
  `labor_desc` text NOT NULL,
  `return_sold_id` int(11) NOT NULL default '0',
  `restocking_fee` text NOT NULL,
  `price_alt` int(11) NOT NULL default '0',
  `addtime` int(11) NOT NULL default '0',
  `pcwo` int(11) NOT NULL default '0',
  `taxex` int(11) NOT NULL default '0',
  `itemtax` decimal(11,2) NOT NULL default '0.00',
  `origprice` decimal(11,2) NOT NULL,
  `discounttype` text NOT NULL,
  `ourprice` decimal(11,2) NOT NULL default '0.00',
  `itemserial` text NOT NULL,
  UNIQUE KEY `cart_item_id` (`cart_item_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- Table structure for table `rinvoice_items`
-- 

CREATE TABLE `rinvoice_items` (
  `cart_item_id` int(11) NOT NULL auto_increment,
  `cart_price` float(11,2) NOT NULL default '0.00',
  `cart_type` text NOT NULL,
  `cart_stock_id` int(11) NOT NULL default '0',
  `labor_desc` text NOT NULL,
  `return_sold_id` int(11) NOT NULL default '0',
  `restocking_fee` text NOT NULL,
  `price_alt` int(11) NOT NULL default '0',
  `addtime` int(11) NOT NULL default '0',
  `rinvoice_id` int(11) NOT NULL,
  `taxex` int(11) NOT NULL default '0',
  `itemtax` decimal(11,2) NOT NULL default '0.00',
  `origprice` decimal(11,2) NOT NULL,
  `discounttype` text NOT NULL,
  `ourprice` decimal(11,2) NOT NULL default '0.00',
  `itemserial` text NOT NULL,
  UNIQUE KEY `cart_item_id` (`cart_item_id`)
) ENGINE=MyISAM AUTO_INCREMENT=76 DEFAULT CHARSET=latin1 AUTO_INCREMENT=76 ;

-- --------------------------------------------------------

-- 
-- Table structure for table `rinvoices`
-- 

CREATE TABLE `rinvoices` (
  `rinvoice_id` int(11) NOT NULL auto_increment,
  `invactive` int(11) NOT NULL default '1',
  `invname` text NOT NULL,
  `invaddy1` text NOT NULL,
  `invaddy2` text NOT NULL,
  `invemail` text NOT NULL,
  `invphone` text NOT NULL,
  `invthrudate` date NOT NULL,
  `reinvoicedate` date NOT NULL,
  `invterms` int(11) NOT NULL default '0',
  `invinterval` text NOT NULL,
  `invcity` text NOT NULL,
  `invstate` text NOT NULL,
  `invzip` text NOT NULL,
  `byuser` text NOT NULL,
  `invnotes` text NOT NULL,
  `storeid` int(11) NOT NULL,
  `pcgroupid` int(11) NOT NULL default '0',
  `invcompany` text NOT NULL,
  KEY `rinvoice_id` (`rinvoice_id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=latin1 AUTO_INCREMENT=6 ;

-- --------------------------------------------------------







-- 
-- Table structure for table `savedcarts`
-- 

CREATE TABLE `savedcarts` (
  `cart_price` float(11,2) NOT NULL default '0.00',
  `cart_type` text NOT NULL,
  `cart_stock_id` int(11) NOT NULL default '0',
  `labor_desc` text NOT NULL,
  `return_sold_id` int(11) NOT NULL default '0',
  `restocking_fee` text NOT NULL,
  `price_alt` int(11) NOT NULL default '0',
  `cartname` text NOT NULL,
  `savedwhen` datetime NOT NULL default '0000-00-00 00:00:00',
  `taxex` int(11) NOT NULL,
  `itemtax` decimal(11,2) NOT NULL,
  `origprice` decimal(11,2) NOT NULL,
  `discounttype` text NOT NULL,
  `ourprice` decimal(11,2) NOT NULL default '0.00',
  `itemserial` text NOT NULL,
  `addtime` int(11) NOT NULL default '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


-- 
-- Table structure for table `savedpayments`
-- 

CREATE TABLE `savedpayments` (
  `paymentid` int(11) NOT NULL auto_increment,
  `pfirstname` text NOT NULL,
  `plastname` text NOT NULL,
  `paddress` text NOT NULL,
  `paddress2` text NOT NULL,
  `pcity` text NOT NULL,
  `pstate` text NOT NULL,
  `pzip` text NOT NULL,
  `pphone` text NOT NULL,
  `pemail` text NOT NULL,
  `receipt_id` text NOT NULL,
  `amount` decimal(11,2) NOT NULL,
  `paymentplugin` text NOT NULL,
  `cc_number` text NOT NULL,
  `cc_expmonth` int(11) NOT NULL,
  `cc_expyear` int(11) NOT NULL,
  `cc_transid` text NOT NULL,
  `cc_confirmation` text NOT NULL,
  `chk_dl` text NOT NULL,
  `chk_number` text NOT NULL,
  `paymentstatus` text NOT NULL,
  `paymenttype` text NOT NULL,
  `paymentdate` datetime NOT NULL,
  `cc_cardtype` text NOT NULL,
  `custompaymentinfo` text NOT NULL,
  `storeid` int(11) NOT NULL,
  `pcompany` text NOT NULL,
  UNIQUE KEY `paymentid` (`paymentid`)
) ENGINE=MyISAM AUTO_INCREMENT=100 DEFAULT CHARSET=latin1 AUTO_INCREMENT=100 ;




-- --------------------------------------------------------

-- 
-- Table structure for table `serviceremindercanned`
-- 

CREATE TABLE `serviceremindercanned` (
  `srid` int(11) NOT NULL auto_increment,
  `srtitle` text NOT NULL,
  `srtext` text NOT NULL,
  `srorder` int(11) NOT NULL,
  UNIQUE KEY `srid` (`srid`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=latin1 AUTO_INCREMENT=8 ;

-- 
-- Dumping data for table `serviceremindercanned`
-- 

INSERT INTO `serviceremindercanned` (`srid`, `srtitle`, `srtext`, `srorder`) VALUES (1, 'Anti-Virus Renewal', 'Your Anti-Virus software subscription will expire soon. Please give us a call or stop in to our store at your convenience to inquire about renewing your subscription so that your computer will continue to be protected by the latest threats.', 20),
(2, 'Dust Cleaning', 'Your computer is due to have the dirt and dust cleaned from the inside. Dust build up is leading cause of overheating. Continued overheating can cause permanent and costly damage to your computer. Please contact us to inquire about having this service performed on your computer.', 30),
(3, 'Computer Tuneup', 'This message is just to remind you that it has been a while since your computer last had a tuneup performed. Regular tuneups can help insure top performance of your computer as well as preventing serious problems that can be caught earlier before they happen. We can also make sure your anti-virus is performing properly. Please contact us to ask about all the details.', 10),
(4, 'Disk Defragmentation & Cleanup', 'It is recommended that your computer be defragged for optimum performance. This is a great task to start before you go to bed for the night. Select the "Defraggler" icon on your desktop and click the defrag button to start the process. \r\n\r\nIt is also recommend to clean out your temp folders by selecting the "CCleaner" icon on your desktop and hitting the "Run Cleaner" button to perform a cleanup on your computer', 15),
(5, 'Thank You for your Business!', 'Thank you for choosing us as your computer service company!', 0),
(6, 'Check Your Backup', 'This is just a reminder to make sure to check your backup system on your computer to make sure it is running correctly. If you would like some help with this, feel free to give us a call.', 25),
(7, 'Get a 20% Discount', 'Bring this page in to receive a free dust cleaning or 20% off the regular price of a full tuneup for this computer. This offer is valid within 14 days of the date at the top of this page', 5);


-- 
-- Table structure for table `servicereminders`
-- 

CREATE TABLE `servicereminders` (
  `srid` int(11) NOT NULL auto_increment,
  `srpcid` int(11) NOT NULL,
  `srnote` text NOT NULL,
  `srdate` date NOT NULL,
  `srcanned` text NOT NULL,
  `srsent` int(11) NOT NULL default '0',
  UNIQUE KEY `srid` (`srid`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=latin1 AUTO_INCREMENT=7 ;



-- 
-- Table structure for table `servicerequests`
-- 

CREATE TABLE `servicerequests` (
  `sreq_id` int(11) NOT NULL auto_increment,
  `sreq_ip` text NOT NULL,
  `sreq_agent` text NOT NULL,
  `sreq_name` text NOT NULL,
  `sreq_homephone` text NOT NULL,
  `sreq_cellphone` text NOT NULL,
  `sreq_workphone` text NOT NULL,
  `sreq_addy1` text NOT NULL,
  `sreq_addy2` text NOT NULL,
  `sreq_city` text NOT NULL,
  `sreq_state` text NOT NULL,
  `sreq_zip` text NOT NULL,
  `sreq_email` text NOT NULL,
  `sreq_problem` text NOT NULL,
  `sreq_model` text NOT NULL,
  `sreq_datetime` datetime NOT NULL,
  `sreq_processed` int(11) NOT NULL default '0',
  `storeid` int(11) NOT NULL default '0',
  `sreq_custsourceid` int(11) NOT NULL default '0',
  `sreq_pcid` int(11) NOT NULL default '0',
  `sreq_company` text NOT NULL,
  PRIMARY KEY  (`sreq_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- Table structure for table `shoplist`
-- 

CREATE TABLE `shoplist` (
  `shopid` int(11) NOT NULL auto_increment,
  `qty` int(11) NOT NULL default '0',
  `itemdesc` text NOT NULL,
  `itemstatus` text NOT NULL,
  `byuser` text NOT NULL,
  `stockid` INT NOT NULL DEFAULT '0',
  UNIQUE KEY `shopid` (`shopid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- 
-- Dumping data for table `shoplist`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `smstext`
-- 

CREATE TABLE `smstext` (
  `smstextid` int(11) NOT NULL auto_increment,
  `smstext` text NOT NULL,
  `theorder` int(11) NOT NULL default '0',
  PRIMARY KEY  (`smstextid`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=latin1 AUTO_INCREMENT=6 ;

-- 
-- Dumping data for table `smstext`
-- 

INSERT INTO `smstext` (`smstextid`, `smstext`, `theorder`) VALUES (1, 'Your repair is completed and ready for pickup!\r\n-PC Repair Tracker', 15),
(2, 'Please call the office at 111-111-1111\r\n-PC Repair Tracker', 10),
(4, 'Please Call the office at 111-111-1111, we need your password\r\n-PC Repair Tracker', 0),
(5, 'Your computer is taking longer than expected, will be ready tomorrow\r\n-PC Repair Tracker', 5);



-- --------------------------------------------------------

-- 
-- Table structure for table `sold_items`
-- 

CREATE TABLE `sold_items` (
  `sold_id` int(11) NOT NULL auto_increment,
  `receipt` int(11) NOT NULL default '0',
  `sold_price` float(11,2) NOT NULL default '0.00',
  `return_flag` text NOT NULL,
  `return_receipt` int(11) NOT NULL default '0',
  `stockid` int(11) NOT NULL default '0',
  `labor_desc` text NOT NULL,
  `sold_type` text NOT NULL,
  `return_sold_id` int(11) NOT NULL default '0',
  `date_sold` datetime NOT NULL default '0000-00-00 00:00:00',
  `taxex` int(11) NOT NULL default '0',
  `itemtax` decimal(11,2) NOT NULL default '0.00',
  `origprice` decimal(11,2) NOT NULL,
  `discounttype` text NOT NULL,
  `price_alt` int(11) NOT NULL default '0',
  `ourprice` decimal(11,2) NOT NULL default '0.00',
  `itemserial` text NOT NULL,
  `addtime` int(11) NOT NULL default '0',
  UNIQUE KEY `sold_id` (`sold_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


-- --------------------------------------------------------


-- --------------------------------------------------------

-- 
-- Table structure for table `stickynotes`
-- 

CREATE TABLE `stickynotes` (
  `stickyid` int(11) NOT NULL auto_increment,
  `stickyaddy1` text NOT NULL,
  `stickyaddy2` text NOT NULL,
  `stickycity` text NOT NULL,
  `stickystate` text NOT NULL,
  `stickyzip` text NOT NULL,
  `stickyphone` text NOT NULL,
  `stickyemail` text NOT NULL,
  `stickyduedate` datetime NOT NULL,
  `stickytypeid` int(11) NOT NULL,
  `stickyuser` text NOT NULL,
  `stickynote` text NOT NULL,
  `stickyname` text NOT NULL,
  `refid` int(11) NOT NULL default '0',
  `reftype` text NOT NULL,
  `showonwall` tinyint(4) NOT NULL default '1',
  `storeid` int(11) NOT NULL,
  `stickycompany` text NOT NULL,
  UNIQUE KEY `stickyid` (`stickyid`)
) ENGINE=MyISAM AUTO_INCREMENT=48 DEFAULT CHARSET=latin1 AUTO_INCREMENT=48 ;





-- 
-- Table structure for table `stickytypes`
-- 

CREATE TABLE `stickytypes` (
  `stickytypeid` int(11) NOT NULL auto_increment,
  `stickytypename` text NOT NULL,
  `bordercolor` text NOT NULL,
  `notecolor` text NOT NULL,
  `notecolor2` text NOT NULL,
  UNIQUE KEY `stickytypeid` (`stickytypeid`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=latin1 AUTO_INCREMENT=8 ;

-- 
-- Dumping data for table `stickytypes`
-- 

INSERT INTO `stickytypes` (`stickytypeid`, `stickytypename`, `bordercolor`, `notecolor`, `notecolor2`) VALUES (1, 'Scheduled Service Call', '00a908', 'ffffff', 'b4ff96'),
(2, 'Return a Call', '0f00d0', 'ffffff', '90f3ff'),
(4, 'Order a Part', 'c48f00', 'ffffff', 'fff889'),
(5, 'Scheduled Remote Session', 'fb4700', 'ffffff', 'ffc990'),
(6, 'Quote Request', 'd9000a', 'ffe4e5', 'ffcdcf'),
(7, 'Task', '960094', 'ffd7ff', 'ff9bfe');



-- 
-- Table structure for table `stock`
-- 

CREATE TABLE `stock` (
  `stock_id` int(11) NOT NULL auto_increment,
  `stock_title` text NOT NULL,
  `stock_desc` text NOT NULL,
  `stock_cat` int(11) NOT NULL default '0',
  `stock_price` float(11,2) NOT NULL default '0.00',
  `dis_cont` int(11) NOT NULL default '0',
  `stock_upc` text NOT NULL,
  UNIQUE KEY `stock_id` (`stock_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1000 DEFAULT CHARSET=latin1 AUTO_INCREMENT=1000 ;


-- --------------------------------------------------------

CREATE TABLE `stockcounts` (
  `stockcountid` int(11) NOT NULL auto_increment,
  `stockid` int(11) NOT NULL,
  `storeid` int(11) NOT NULL,
  `quantity` int(11) NOT NULL default '0',
  `lastcounted` datetime NOT NULL,
  PRIMARY KEY  (`stockcountid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;



CREATE TABLE `stores` (
  `storeid` int(11) NOT NULL auto_increment,
  `storesname` text NOT NULL,
  `storename` text NOT NULL,
  `storeaddy1` text NOT NULL,
  `storeaddy2` text NOT NULL,
  `storecity` text NOT NULL,
  `storestate` text NOT NULL,
  `storezip` text NOT NULL,
  `storeemail` text NOT NULL,
  `storephone` text NOT NULL,
  `storedefault` int(11) NOT NULL default '0',
  `storeenabled` int(11) NOT NULL default '1',
  `quotefooter` text NOT NULL,
  `invoicefooter` text NOT NULL,
  `repairsheetfooter` text NOT NULL,
  `returnpolicy` text NOT NULL,
  `depositfooter` text NOT NULL,
  `thankyouletter` text NOT NULL,
  `claimticket` text NOT NULL,
  `linecolor1` varchar(6) NOT NULL default '65FF00',
  `linecolor2` varchar(6) NOT NULL default '439600',
  `bgcolor1` varchar(6) NOT NULL default 'b5bdc8',
  `bgcolor2` varchar(6) NOT NULL default '28343b',
  `storehash` text NOT NULL,
  `ccemail` text NOT NULL,
  `oncalluser` text NOT NULL,
  UNIQUE KEY `storeid` (`storeid`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;


INSERT INTO `stores` (`storeid`, `storesname`, `storename`, `storeaddy1`, `storeaddy2`, `storecity`, `storestate`, `storezip`, `storeemail`, `storephone`, `storedefault`, `storeenabled`, `quotefooter`, `invoicefooter`, `repairsheetfooter`, `returnpolicy`, `depositfooter`, `thankyouletter`, `claimticket`) VALUES (1, 'Store 1', 'My Business Name', 'MyAddress', '', 'MyCity', 'MyZip', '12345', 'me@email.com', '123-123-1234', 1, 1, '<font class=text16b>Thank-You for your consideration.</font><br><font class=text12>Please note that these prices are subject to change.</font>', '<font class=text16b>Thank-You for your patronage.</font><br><font class=text12>Please pay this invoice within 2 weeks of the invoice date.</font>', '<font class=text10> End of Report</font>', '<font class=text10b> Return Policy:</font><font class=text10> Motherboards, memory and processors must be returned within 7 days for refund. All other items that are returned or exchanged for different items are subject to a 20% restocking fee.\r\n We may, at our discretion only charge a 5% restocking fee provided the item is returned with non-ripped packaging in un-used condition. Items must be returned with a receipt. No returns or refunds on consumable items, printer cartridges, services, or items returned incomplete or without all original packaging. All returns over $25 are either credited back to the customers credit card, or issued a company check within 14 days.</font>', '<font class=text10b>Deposit Policy:</font> <font class=text10> Please keep this receipt for your own records.</font>', '<font class=text12b>Thank-You for choosing My Company for your recent service work.</font>\r\n\r\n<font class=text12>We want you to be satisfied with the level of service we have provided you. If you have any further issues or questions, do not hesitate to contact us. We want you to be 100% satisfied with our work.\r\n\r\nWe also welcome feedback and reviews on our Google Places page located here: <a href=http://g.co/maps/>My Google Places Page</a>. If you have any immediate issues though, be sure to contact us directly, we are ready and eager to solve any issue.\r\n\r\nThanks Again for choosing us, and please remember us for any future needs.\r\n\r\nSincerely,\r\nThe Staff of My Company</font>', '<font class=text12b>Thank-You for choosing My Company to repair your computer.\r\nPlease keep this ticket and present at the time of pick-up of your computer.</font>\r\n\r\n<font class=text12>Please be advised that while nothing will be done by our techs to purposely cause loss of data and files from your computer, mechanical failure of computer components can happen with out warning, and virus infections can cause un-predictable problems. If you have important information on your computer such as family pictures or financial records, and wish to minimize your risk of data loss, please inquire about our back up services which can be performed before intensive diagnostic tests or virus scans are performed.\r\n\r\nPlease keep in mind also that if the Operating System Reload Service is required, you will be contacted first by us before we perform the service. You may opt to have us backup your information before we perform the service for an additional charge. An Operating System Reload requires that the computer hard drive be formatted and erased before reinstalling the Operating System software. An Operating System reload also requires that you reinstall all printer drivers, and additional computer programs you may have installed since the original purchase of the computer. We cannot restore computer programs from backup. They must be re-installed from their original sources.\r\n\r\nFeel free to call us to check on the status of your computer any time. Most repairs take 1-4 business days to complete.\r\nIf you would like to see your computer repaired as fast as possible, feel free to call us and ask about the possibility and costs of a memory upgrade that can speed up the repair process.</font>\r\n\r\n<font class=text12b>Abandoned Computers</font>\r\n<font class=text12>Computers that are diagnosed as non-repairable or not cost effective for repair, will be disposed of if abandoned for over 60 days at our sole discretion. Any computers abandoned over 180 days without prior arrangements will be disposed of at our discretion. It is the customers responsibility to verify that we have the correct contact information on file which also appears printed on this sheet.</font>');


-- 
-- Table structure for table `storevars`
-- 

CREATE TABLE `storevars` (
  `varid` int(11) NOT NULL auto_increment,
  `value` text NOT NULL,
  `varname` text NOT NULL,
  UNIQUE KEY `varid` (`varid`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;


-- 
-- Table structure for table `sub_cats`
-- 

CREATE TABLE `sub_cats` (
  `sub_cat_id` int(11) NOT NULL auto_increment,
  `sub_cat_name` text NOT NULL,
  `sub_cat_item_total` int(11) NOT NULL default '0',
  `sub_cat_parent` int(11) NOT NULL default '0',
  UNIQUE KEY `sub_cat_id` (`sub_cat_id`)
) ENGINE=MyISAM AUTO_INCREMENT=101 DEFAULT CHARSET=latin1 AUTO_INCREMENT=101 ;

-- 
-- Dumping data for table `sub_cats`
-- 

INSERT INTO `sub_cats` (`sub_cat_id`, `sub_cat_name`, `sub_cat_item_total`, `sub_cat_parent`) VALUES (3, '56k Modems', 0, 4),
(4, 'Printer Cables', 0, 8),
(5, 'Sound Cards', 0, 9),
(6, 'USB Cables', 1, 8),
(7, 'KVM & Monitor Cables', 0, 8),
(8, 'Cases', 0, 11),
(9, 'Power Supplies', 0, 11),
(10, 'Memory Card Readers', 0, 5),
(11, 'CD-ROM', 0, 1),
(12, 'CD-RW', 0, 1),
(13, 'DVD-ROM', 0, 1),
(14, 'Game Controllers', 0, 7),
(15, 'Keyboards', 0, 2),
(16, 'Mice', 0, 2),
(17, 'Mouse Pads', 0, 2),
(18, 'Network Cards', 0, 4),
(19, 'Wireless Routers', 0, 4),
(20, 'Network Hubs & Switches', 0, 4),
(21, 'Wireless Network Cards', 0, 4),
(22, 'Floppy Drives', 0, 1),
(23, 'AGP Video Cards', 0, 6),
(24, 'Headphones', 0, 9),
(25, 'Surge Protectors', 0, 11),
(40, 'Serial Cables', 0, 8),
(68, 'PC Mods', 0, 11),
(56, 'InkJet', 0, 16),
(26, 'USB Hubs', 0, 8),
(38, 'Network & Ethernet', 0, 8),
(33, 'Cleaners', 0, 12),
(35, 'Speaker Systems', 0, 9),
(84, 'Inkjet Cartridges', 0, 16),
(82, 'RAM - DDR2', 0, 17),
(89, 'Notebook Computers', 0, 19),
(27, 'Controller Cards', 0, 8),
(44, 'DSL Modems', 0, 4),
(34, 'Game Adapters/Cables', 0, 7),
(47, 'CDRW DVD Combo Drives', 0, 1),
(29, 'CDR Blank Disks', 0, 15),
(30, 'Wireless Mice/Keyboards', 0, 2),
(46, 'Motherboards - Intel', 0, 17),
(45, 'CPU - Intel ', 0, 17),
(55, 'Racks and Cages', 0, 1),
(53, 'CD DVD Cases', 0, 15),
(62, 'Floppy Disks', 0, 15),
(76, 'PCI Express', 0, 6),
(85, 'Corded Phones', 0, 20),
(80, 'Custom Ready Built Systems', 0, 19),
(31, 'Routers', 0, 4),
(32, 'All-in-one ', 0, 16),
(41, 'CPU - AMD', 0, 17),
(60, 'Microphones', 0, 9),
(50, 'Operating Systems', 0, 18),
(54, 'RAM - SDRAM', 0, 17),
(88, 'Cases', 0, 15),
(36, 'CPU Fans & Heatsinks', 0, 17),
(43, 'Case Fans', 0, 11),
(37, 'Power Splitters & Adapters', 0, 11),
(39, 'Keyboard Adapters', 0, 8),
(42, 'Web Cams', 0, 6),
(90, 'Notebook Accessories', 0, 19),
(75, 'Special Order', 0, 12),
(52, 'UPS', 0, 11),
(51, 'DVD Media', 0, 15),
(59, 'Drive Cables', 0, 8),
(48, 'RAM - DDR', 0, 17),
(58, 'DVD-RW', 0, 1),
(66, 'USB Flash Drives', 0, 1),
(61, 'Phone Cords & Adapters', 0, 8),
(49, '3.5 IDE Hard Drives', 0, 1),
(64, 'Driver Controllers', 0, 1),
(81, 'Used Systems', 0, 19),
(72, 'Batteries', 0, 12),
(57, 'Flatbed Scanners', 0, 16),
(65, 'CD Labels', 0, 15),
(73, 'PCI Video Cards', 0, 6),
(71, 'Office Suites', 0, 18),
(91, 'Coax', 0, 8),
(63, 'Motherboards - AMD', 0, 17),
(69, 'Monitors/Displays', 0, 6),
(70, 'Video Capture', 0, 6),
(77, 'Mice -- Generic', 0, 2),
(67, 'Audio Cables', 0, 8),
(79, 'RAM - SODIMMS', 0, 17),
(74, 'Printer Paper', 0, 12),
(78, 'Keyboards - Generic', 0, 2),
(83, '3.5 SATA Hard Drives', 0, 1),
(86, 'Cordless Phones', 0, 20),
(87, 'Media Other', 0, 15),
(92, 'Speaker Wire', 0, 8),
(93, 'AC Power', 0, 8),
(94, 'AV Cables', 0, 8),
(95, 'External Hard Drives', 0, 1),
(98, 'Memory Cards', 0, 15),
(100, 'Toners', 0, 16),
(96, '2.5 IDE Hard Drives', 0, 1),
(97, '2.5 SATA Hard Drive', 1, 1),
(99, 'Laser Printers', 0, 16);



-- 
-- Table structure for table `taxes`
-- 

CREATE TABLE `taxes` (
  `taxid` int(11) NOT NULL auto_increment,
  `taxname` text NOT NULL,
  `taxrateservice` decimal(11,5) NOT NULL default '0.00000',
  `taxrategoods` decimal(11,5) NOT NULL default '0.00000',
  `taxenabled` int(11) NOT NULL default '1',
  PRIMARY KEY  (`taxid`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=latin1 AUTO_INCREMENT=5 ;

-- 
-- Dumping data for table `taxes`
-- 

INSERT INTO `taxes` (`taxid`, `taxname`, `taxrateservice`, `taxrategoods`) VALUES (0, 'Tax Exempt', 0.00, 0.00),
(1, 'Old Tax Rate', 0.00, 0.00);


-- 
-- Table structure for table `techdocs`
-- 

CREATE TABLE `techdocs` (
  `techdoccatid` int(11) NOT NULL auto_increment,
  `techdoccatname` text NOT NULL,
  UNIQUE KEY `techdoccatid` (`techdoccatid`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=latin1 AUTO_INCREMENT=13 ;

-- 
-- Dumping data for table `techdocs`
-- 

INSERT INTO `techdocs` (`techdoccatid`, `techdoccatname`) VALUES (1, 'Windows XP'),
(2, 'Windows 7'),
(3, 'Windows Vista'),
(4, 'Networking'),
(5, 'Virus Removal'),
(6, 'Hardware'),
(7, 'Apple - MAC'),
(8, 'Printers'),
(9, 'Routers'),
(10, 'Software'),
(12, 'Other');

-- --------------------------------------------------------



CREATE TABLE `userlog` (
  `userlogid` int(11) NOT NULL auto_increment,
  `actionid` int(11) NOT NULL,
  `thedatetime` datetime NOT NULL,
  `refid` int(11) NOT NULL,
  `reftype` varchar(15) NOT NULL,
  `loggeduser` varchar(30) NOT NULL,
  `mensaje` TEXT NOT NULL,
  UNIQUE KEY `userlogid` (`userlogid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;



-- --------------------------------------------------------

-- 
-- Table structure for table `users`
-- 


CREATE TABLE `users` (
  `userid` int(11) NOT NULL auto_increment,
  `username` text NOT NULL,
  `userpass` text NOT NULL,
  `currenttaxid` int(11) NOT NULL default '1',
  `scanrecordview` int(11) NOT NULL default '0',
  `theperms` text NOT NULL,
  `lastseen` datetime NOT NULL,
  `touchrefresh` int(11) NOT NULL default '300',
  `gomodal` tinyint(1) NOT NULL default '0',
  `touchwide` tinyint(4) NOT NULL default '3',
  `stickywide` tinyint(4) NOT NULL default '3',
  `autoprint` tinyint(4) NOT NULL default '1',
  `touchview` int(11) NOT NULL default '2',
  `floatbar` int(11) NOT NULL default '1',
  `defaultstore` int(11) NOT NULL default '0',
  `statusview` int(11) NOT NULL default '0',
  `useremail` text NOT NULL,
  `usermobile` text NOT NULL,
  PRIMARY KEY  (`userid`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=latin1 AUTO_INCREMENT=5 ;


-- 
-- Dumping data for table `users`
-- 

INSERT INTO `users` (`userid`, `username`, `userpass`, `currenttaxid`, `theperms`, `lastseen`, `defaultstore`) VALUES (1, 'admin', '3c41ff681c1e3dcb68b4d8573bf1c74c', 0, '',NOW(),'1');
